' *************************************** SIGNAL GENERATOR *****************************************
'
' Precision signal generator using AD9851 with 30*6 MHz clock
'
' Runs on CSE210902.PCB, using ATMega644P
'
' EEPROM usage
'
' 1 -  MHz Factor correction

$regfile = "M644def.dat"                                    ' Chip description
$hwstack = 160                                              ' make sure stacks big enough
$swstack = 160
$framesize = 160

$crystal = 20000000                               ' 8MHz clock, 3.3V

Waitms 50

Config Com1 = 115200 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0

Ddra = &B0001_1100                                ' bits 2..4 control AD9833
Porta = &B0001_1000

Ddrb = &B0101_0111                                ' Port B
Portb = &B010_1000

Ddrc = &B1111_0000                                ' Port C direction all inputs
Portc = &B0000_1100                               ' Port C pullups

Ddrd = &B1111_0000
Portd = &B0000_1111


' ******************************** LONG ***********************************************************

Dim Frequency As Dword
Dim Phase As Dword
Dim Phase_save As Dword
Dim New_phase As Dword
Dim Intermediate_1 As Dword
Dim Intermediate_2 As Dword
Dim Mhz_count As Dword
Dim Khz_count As Dword
Dim Hz_count As Dword
Dim Last_frequency As Dword
Dim Mhz_factor As Dword
Dim Khz_factor As Dword
Dim Step_increment As Dword
Dim Mod_frequency As Dword
Dim Phase_register As Dword
Dim Phase_deviation As Dword
Dim Adc0_sample As Word
Dim Previous_adc0_sample As Word
Dim Function_diff As Integer

' ******************************** WORD ***********************************************************

Dim Dac_out As Word                               ' output to DAC
Dim Battery As Word                               ' battery voltage

Dim Modulation_potentiometer As Word              ' AM or FM modulation frequency
Dim Previous_mod_freq As Word
Dim Timer_constant As Word
Dim Modulation_frequency As Word
Dim Carrier As Word
Dim Power_indication As Word
Dim Difference As Integer
Dim Adc1_sample As Word
Dim Control_register As Word
Dim Mod_diff As Integer

Dim Phase_high As Dword
Dim Phase_low As Dword
Dim Previous_adc1_sample As Word
Dim Mod_number As Word
Dim Phase_h As Word
Dim Phase_l As Word
Dim Adc1_reading As Word
Dim Adc0_reading As Word
Dim Deviation As Word
Dim Fm_reload As Word


'*************** BYTE ***********************************************************

Dim W_0 As Byte
Dim W_1 As Byte                                             ' AD9851 loads
Dim W_2 As Byte
Dim W_3 As Byte
Dim W_4 As Byte
Dim Step_counter As Byte                          ' from 12 position switch
Dim Encoder_value As Byte
Dim 100hz_timer As Byte
Dim Dac_low As Byte
Dim Dac_high As Byte
Dim Opmode As Byte
Dim Sample_number As Byte                         ' samples for sine wave generation
Dim Dac_load As Byte
Dim Battery_timer As Byte
Dim Flash_timer As Byte
Dim Low_nybble As Byte
Dim High_nybble As Byte
Dim Correction As Byte
Dim Previous_opmode As Byte
Dim Fm_sample As Byte
Dim Func_value As Word
Dim Deviation_value As Byte
Dim Fm_dev As Byte
Dim Mod_save As Byte

' ********************************* BIT ***********************************************************

Dim Frequency_up As Bit
Dim Frequency_down As Bit
Dim Dac_sample As Bit
Dim Check_battery As Bit
Dim Flash_bit As Bit
Dim Battery_low As Bit
Dim Blank_bit As Bit
Dim Step_pulse As Bit
Dim Calibration_flag As Bit
Dim Freq_tune As Bit
Dim Opmode_1 As Bit
Dim Fm_timer As Bit
Dim Sample_bit As Bit
Dim Polarity As Bit
Dim Direction As Bit

' ***************************************** ALIASES ***********************************************

Cr Alias &H0D                                     ' carriage return
Lf Alias &H0A                                     ' line feed
Esc Alias &H06

' AD9851 controls

Fq_ud Alias Portb.0
Reset_ad9851 Alias Portb.2                        ' pulse high to reset AD9851
W_clock Alias Portb.4

' AD9833 controls

Fsync Alias Porta.4
9833clk Alias Porta.3
9833data Alias Porta.2

 Fm_reload = 760                                  ' start at 1000 Hz

' Timer 0 Interrupts About 100 Times / Second.

'Config Timer0 = Timer , Prescale = 1024
'Timer0 = 255 - 195

Config Timer1 = Timer , Prescale = 1              ' gives 9600/sec interrupt
Timer1 = 65536 - Fm_reload


Config Int0 = Falling
Config Int1 = Falling
Config Adc = Single , Prescaler = Auto , Reference = Aref       ' use 3.3V external ref


I2cinit

Const Mcp4725w = &HC0                             ' Addresses of DAC
Const Mcp4725r = &HC1
Config Clock = User

' For AD9851  23860929
   Readeeprom Correction , 1
   Mhz_factor = 23860736 + Correction             ' this is for AD9851 with 180 MHz clock
   Khz_factor = Mhz_factor / 10


' For AD9833
' 1000 Hz = 8312H = 13422 at 20 MHz

'On Timer0 100hz_interrupt
On Timer1 Timer1_interrupt                        ' , Nosave
On Int0 Rotary_encoder
On Int1 Step_size

'Enable Timer0
Enable Int0
Enable Int1
Enable Interrupts

Print "AD9851 Signal Generator V.2.8" ; Chr(cr);
$lib "i2c_twi.lbx"                                ' we do not use software emulated I2C but the TWI
'$lib "glcdSSD1306-I2C_V2.lib"
$lib "glcdSSD1306-I2C.lib"                        ' override the default lib with this special one
Waitms 200

Frequency_up = 0
Frequency_down = 0

I2cinit

'$lib "i2c_twi.lbx"                                ' we do not use software emulated I2C but the TWI

Config Scl = Portc.0                              ' used i2c pins
Config Sda = Portc.1
Config Twi = 400000                               ' i2c speed
Config Graphlcd = Custom , Cols = 128 , Rows = 64 , Lcdname = "SSD1306"
I2cinit
'$include "font8x8tt.font"
'Setfont Font8x8tt                                 ' select font

Setfont Font16x16
'  Cls

  Lcdat 1 , 1 , " AD9851 " , 2
  Lcdat 3 , 1 , "SIG GEN " , 2
  Lcdat 5 , 1 , "VER  2.8" , 2
  Lcdat 7 , 1 , "        " , 2


  Wait 2
  Cls


  Step_counter = 0


  Gosub Reset_ad9833

  Frequency = 10000000                            ' starting frequency
  Reset_ad9851 = 1                                ' reset chip
  Waitus 5
  Reset_Ad9851 = 0

  Gosub Ad9851_load
  Gosub Oled_frequency_load
  Gosub Show_mod

  Previous_adc0_sample = 1000                     ' start with new
  Gosub Read_rv2
  If Deviation_value = 1 Then Lcdat 3 , 1 , "1Hz  2.5" , 2
  If Deviation_value = 2 Then Lcdat 3 , 1 , "1Hz  5.0" , 2
  If Deviation_value = 3 Then Lcdat 3 , 1 , "1Hz   10" , 2


' ********************************************* MAIN ***********************************************
'
' Monitor shaft encoder, switches, potentiometers, battery level

Main:
   If Frequency_up = 1 Then Gosub Increase_frequency
   If Frequency_down = 1 Then Gosub Decrease_frequency
   If Step_pulse = 1 Then Gosub Adjust_step
   If Freq_tune = 1 Then Gosub Ad9851_load
   Gosub Read_rv2                                 ' read potentiometer
   Gosub Operating_mode
   If Opmode <> 1 Then Gosub Sleep_ad9833
   Gosub Set_mod_frequencies
   If Opmode = 2 Then Enable Timer1 Else Disable Timer1

   If Opmode = 2 Then Gosub Fm_mode

   '  If Check_battery = 1 Then Gosub Measure_battery       ' see if battery < 4V
   ' If Battery_low = 1 Then Gosub Flash_low_battery

  Goto Main



' ***************************************** MEASURE BATTERY ****************************************
'
' Measure battery voltage. Full scale is 3.3V or 1023 counts. If count is below 900
' flash message on bottom line.


Measure_battery:
   Check_battery = 0                              ' reset flag
   Battery = Getadc(4)
   If Battery < 900 Then Set Battery_low
   Return

' Flash low battery puts BAT LOW on bottom line flashing 1 scond on and 1 second off

Flash_low_battery:
   Battery_low = 0                                ' reset flag
   If Flash_bit = 1 Then Lcdat 8 , 1 , "BAT LOW"
   Flash_bit = 0
   If Blank_bit = 1 Then Lcdat 8 , 1 , "        "
   Blank_bit = 1
   Return


' ********************************* ADJUST STEP ***********************************************
'

Adjust_step:
   Step_pulse = 0
   If Calibration_flag = 1 Then Writeeeprom Correction , 1       ' update correction
   If Calibration_flag = 1 Then Goto As_exit
   Incr Step_counter
   If Step_counter => 6 Then Step_counter = 0     ' wrap around
   Print "Step = " ; Step_counter ; Chr(cr);
   If Deviation_value = 1 Then Gosub Dev_25
   If Deviation_value = 2 Then Gosub Dev_50
   If Deviation_value = 3 Then Gosub Dev_100
As_exit:
   Return

Dev_25:
   If Step_counter = 0 Then Lcdat 3 , 1 , "1Hz  2.5" , 2
   If Step_counter = 1 Then Lcdat 3 , 1 , "100  2.5" , 2
   If Step_counter = 2 Then Lcdat 3 , 1 , "1kHz 2.5" , 2
   If Step_counter = 3 Then Lcdat 3 , 1 , "10k  2.5" , 2
   If Step_counter = 4 Then Lcdat 3 , 1 , "100k 2.5" , 2
   If Step_counter = 5 Then Lcdat 3 , 1 , "1MHz 2.5" , 2
   Return


Dev_50:
   If Step_counter = 0 Then Lcdat 3 , 1 , "1Hz  5.0" , 2
   If Step_counter = 1 Then Lcdat 3 , 1 , "100  5.0" , 2
   If Step_counter = 2 Then Lcdat 3 , 1 , "1kHz 5.0" , 2
   If Step_counter = 3 Then Lcdat 3 , 1 , "10k  5.0" , 2
   If Step_counter = 4 Then Lcdat 3 , 1 , "100k 5.0" , 2
   If Step_counter = 5 Then Lcdat 3 , 1 , "1MHz 5.0" , 2
   Return

Dev_100:
   If Step_counter = 0 Then Lcdat 3 , 1 , "1Hz   10" , 2
   If Step_counter = 1 Then Lcdat 3 , 1 , "100   10" , 2
   If Step_counter = 2 Then Lcdat 3 , 1 , "1kHz  10" , 2
   If Step_counter = 3 Then Lcdat 3 , 1 , "10k   10" , 2
   If Step_counter = 4 Then Lcdat 3 , 1 , "100k  10" , 2
   If Step_counter = 5 Then Lcdat 3 , 1 , "1MHz  10" , 2
   Return

' ***************************************** MODE OF OPERATION **************************************
'
' Modes of operation are:
' Carrier
' Amplitude Modulation
' Frequency Modulation
'
' The selection is done by toggle switch on PC.2 and PC.3
' Mode = 11 gives Carrier
' Mode = 10 gives AM
' Mode = 01 gives FM
' Returns mode in Opmode byte



Operating_mode:
   Opmode = Pinc And &B0000_1100                  ' read bits 2 and 3
   Rotate Opmode , Right , 2                      ' puts it into low 2 bits
   If Opmode <> Previous_opmode Then Gosub Show_opmode
   If Opmode = Previous_opmode Then Goto Op_exit
   Previous_opmode = Opmode
   If Opmode = 1 Then Opmode_1 = 1                'set flag
   Step_pulse = 0
 '  Step_counter = 1
Op_exit:
      Return


Show_opmode:
   Print "Opmode=" ; Opmode ; Chr(cr);
  ' Lcdat 3 , 1 , "Mod frequencies "
   If Opmode = 1 Then Lcdat 7 , 1 , "        " , 2
 '  If Opmode <> 2 Then Lcdat 6 , 1 , "               "
 '  Step_counter = 1
   Return


' ******************************** 100HZ INTERRUPT, TIMER0 ****************************************
'
' Timer 1 interrupts every 100 Hz approx. Used for various timing functions.
' Battery is checked every second


100hz_interrupt:
   Timer0 = 255 - 78
   Incr Battery_timer
   If Battery_timer = 100 Then Check_battery = 1  ' set flag
   If Battery_timer => 100 Then Battery_timer = 0
   Incr Flash_timer
   If Flash_timer = 100 Then Set Flash_bit
   If Flash_timer = 200 Then Set Blank_bit
   If Flash_timer = 200 Then Flash_timer = 0
    Return


' ******************************** 9600HZ INTERRUPT, TIMER0 ****************************************
'
' Timer 1 interrupts for FM sampling.
' Interrupt rate is according to modulation frequency.
'
'  Frequency    Interrupt Rate   Timer reload
' -------------------------------------------
'      50             1200          16667
'     100             2400          8333
'     200             4800          4167
'     400             9600          2083
'     500            12000          1667
'     600            14400          1389
'     700            16800          1190
'     800            19200          1042
'     900            21600           926
'    1000            24000           833




Timer1_interrupt:
    Timer1 = 65536 - Fm_reload
   ' Toggle Portb.6

    Set Sample_bit
    Incr Fm_sample
    If Fm_sample = 12 Then Toggle Polarity
    If Fm_sample = 12 Then Fm_sample = 0
    Return


Fm_mode:


    If Frequency_up = 1 Then Gosub Increase_frequency
    If Frequency_down = 1 Then Gosub Decrease_frequency
    If Step_pulse = 1 Then Gosub Adjust_step
    If Sample_bit = 1 Then Gosub Frequency_modulation
    Gosub Operating_mode
    If Opmode = 2 Then Goto Fm_mode               ' loop here till exit
    Phase = Phase_save                            ' restore frequency
    Gosub Ad9851_load                             ' and load again
    Return


' ********************************** INCREASE FREQUENCY *******************************************
'
' Increase frequency by what is in step counter

Increase_frequency:
   Frequency_up = 0                               ' reset flag
  ' Frequency_down = 0
   Gosub Increment_size
   Frequency = Frequency + Step_increment
   If Frequency > 75000000 Then Frequency = 75000000       ' limit 75 MHz
   Gosub Ad9851_load
 '  If Opmode <> 2 Then
    Gosub Oled_frequency_load
   Return


Increment_size:
   If Step_counter = 0 Then Step_increment = 1
   If Step_counter = 1 Then Step_increment = 100
   If Step_counter = 2 Then Step_increment = 1000
   If Step_counter = 3 Then Step_increment = 10000
   If Step_counter = 4 Then Step_increment = 100000
   If Step_counter = 5 Then Step_increment = 1000000
   Return


' ********************************** DECREASE FREQUENCY *******************************************
'
' Decrease frequency by what is in step counter

Decrease_frequency:
   Frequency_down = 0                             ' reset flag
   If Frequency = 100000 Then Goto Df_exit
   Gosub Increment_size
   Frequency = Frequency - Step_increment
   If Frequency < 100000 Then Frequency = 100000  'minimum 100 kHz
   Gosub Ad9851_load
   'If Opmode <> 2 Then
    Gosub Oled_frequency_load
Df_exit:
   Return

' ******************************* OLED FREQUENCY LOAD **********************************************
'
' OLED frequency load puts frequency on top line.

Oled_frequency_load:
   Frequency_up = 0
   Frequency_down = 0
   'Print "Freq= " ; Frequency ; " Hz " ; Chr(cr);
   If Frequency => 10000000 Then Lcdat 1 , 1 , Frequency , 2
   Gosub Lower_frequency
   Return

Lower_frequency:
   If Frequency < 1000000 Then Lcdat 1 , 1 , "  " ; Frequency , 2
   If Frequency < 1000000 Then Goto Lf_exit
   If Frequency < 10000000 Then Lcdat 1 , 1 , " " ; Frequency , 2
Lf_exit:
   Return


' ******************************* OLED MODULATION LOAD *********************************************
'
' OLED modulation load puts mod frequency on 4th line.

Oled_modulation_load:
  ' Lcdat 5 , 1 , "Mod " ; Modulation_frequency
   Print "Mod freq = " ; Modulation_frequency ; Chr(cr);
   Return

' ****************************** AD9851 SETUP *****************************************************
'
' This sets frequency of AD9851 by uploading 5 bytes
' Entry is Frequency in Hz
'
' fout=(phase * system clock)/2**32
'
' Hence phase = 2**32 fout/system clock
'
'
' Data bits 0..3 from PORTD4..7
' Data bits 4..7 from PORTC4..7

Ad9851_load:

   Mhz_count = Frequency / 1000000                ' get MHz
   Intermediate_1 = Frequency Mod 1000000         ' gives remainder
   Khz_count = Intermediate_1 / 1000              ' get KHz
   Hz_count = Intermediate_1 Mod 1000             ' get Hz
   Phase = Mhz_count * Mhz_factor
   Intermediate_1 = Khz_count * Khz_factor
   Intermediate_1 = Intermediate_1 / 100
   Phase = Phase + Intermediate_1
   Intermediate_2 = Hz_count * Khz_factor
   Intermediate_2 = Intermediate_2 / 100000
   Phase = Phase + Intermediate_2
   Phase_save = Phase
   Print "Frequency = " ; Frequency ; "Hz" ; " Phase = " ; Phase ; Chr(cr);

   ' now separate out the 4 bytes

   W_4 = Phase
   Rotate Phase , Right , 8
   W_3 = Phase
   Rotate Phase , Right , 8
   W_2 = Phase
   Rotate Phase , Right , 8
   W_1 = Phase
  ' Reset Portb.6

   Gosub Upload_five
   Waitus 100
   Return


 Upload_five:


   Portd = &B0001_0000                            ' PD.4 is bit 0 of load = X6 clock
 '  Portd = &B0000_0000                            ' PD.4 is bit 0 of load = X1 clock
   Portc = &B0000_0000                            ' W0 = 00000001
   W_clock = 1                                    ' load first byte
   W_clock = 0

   Low_nybble = W_1
   Swap Low_nybble
   Portd = Low_nybble
   High_nybble = W_1
   Portc = High_nybble
   W_clock = 1
   W_clock = 0

   Low_nybble = W_2
   Swap Low_nybble
   Portd = Low_nybble
   High_nybble = W_2
   Portc = High_nybble
   W_clock = 1
   W_clock = 0

   Low_nybble = W_3
   Swap Low_nybble
   Portd = Low_nybble
   High_nybble = W_3
   Portc = High_nybble
   W_clock = 1
   W_clock = 0

   Low_nybble = W_4
   Swap Low_nybble
   Portd = Low_nybble
   High_nybble = W_4
   Portc = High_nybble
   W_clock = 1
   W_clock = 0

   Fq_ud = 1                                      ' Frequency update FQ_UD pulse
   Fq_ud = 0

Load_exit:
   Return




' ************************************ STEP SIZE **************************************************
'
' PB switch on encoder toggles through step sizes.
' Steps are 1Hz, 100Hz, 1khz, 10kHz, 100kHz and 1MHz
' Returns step_counter value 0 to 5

Step_size:
   Waitms 20                                      ' contact bounce
   Set Step_pulse
   Return


' ********************************* ROTARY ENCODER ************************************************
'
' Rotary encoder steps frequency up or down



Rotary_encoder:
   Direction = not Pinb.5

   Waitms 2                                       ' contact bounce
   If Calibration_flag = 0 Then Gosub Freq_adjust
   If Calibration_flag = 1 Then Gosub Calib_adjust
   Return

Freq_adjust:
   If Pinb.3 = Direction Then Frequency_down = 1 Else Frequency_up = 1

   Return

Calib_adjust:
   If Pinb.3 = Direction Then Decr Correction Else Incr Correction
   If Pinb.3 = Direction Then Decr Mhz_factor Else Incr Mhz_factor
   If Correction = 0 Then Lcdat 7 , 1 , "O_=" ; 0
   Print "O_=" ; Correction ; Chr(cr);
   Lcdat 7 , 1 , Mhz_factor
   Set Freq_tune
   Return

' **************************** SLEEP AD9833 **********************************************

Sleep_ad9833:
   Fsync = 0
   Waitus 1
   Control_register = &B0000_0001_1000_0000       ' reset chip by setting bit 8
   Shiftout 9833data , 9833clk , Control_register , 0 , 16
   Waitus 1
   Fsync = 1
   Return


' **************************** RESET AD9833 **********************************************

Reset_ad9833:
   Fsync = 0
   Waitus 1
   Control_register = &B0000_0001_0000_0000       ' reset chip by setting bit 8
   Shiftout 9833data , 9833clk , Control_register , 0 , 16
   Control_register = &B0000_0000_0000_0000       ' and resetting bit 8
   Shiftout 9833data , 9833clk , Control_register , 0 , 16
   Waitus 1
   Fsync = 1
   Return


' ***************************************** MODULATION *********************************************
'
' Read potentiometer RV2 to set frequency. This will be in range 50 to 10000Hz.
' Load AD9833 with frequency.
' With 8 MHz clock phase register for 1000 Hz = 8312H = 33554
' 10 kHz gives 51EB8H = 335544
' Use 10 frequencies - 50, 100, 200, 400, 1000, 2000, 3000, 4000, 5000,10000
' Divide ADC by 100 for these
'



'Fsync Alias Porta.4
'9833clk Alias Porta.3
'9833data Alias Porta.2
'
Set_mod_frequencies:
   Adc1_reading = Getadc(1)                       ' gets value 0-1023
   Adc1_sample = Adc1_reading
   Adc1_reading = Getadc(1)
   Adc1_sample = Adc1_sample + Adc1_reading
   Adc1_reading = Getadc(1)
   Adc1_sample = Adc1_sample + Adc1_reading
   Adc1_reading = Getadc(1)
   Adc1_sample = Adc1_sample + Adc1_reading
   Adc1_sample = Adc1_sample / 4                  ' get average
   Mod_diff = Adc1_sample - Previous_adc1_sample
   If Opmode_1 = 1 Then Goto Am_10
   If Abs(mod_diff) < 30 Then Goto Mod_exit       ' only for => 30
      Previous_adc1_sample = Adc1_sample
Am_10:
   Opmode_1 = 0
  '  Print "ADC=" ; Adc1_sample ; Chr(cr);
   Gosub Mod_to_frequency
   Gosub Reset_ad9833
   Phase_register = Mod_frequency * 13422         ' load into 32 bit word
   Phase_register = Phase_register / 1000

   Phase_high = Phase_register / 16384            ' get top 14 bits
   Phase_high = Phase_high Or &B0100_0000_0000_0000       ' set bit 14
   Phase_h = Phase_high
   Phase_low = Phase_register Mod 16384           ' get low 14 bits
   Phase_low = Phase_low Or &B0100_0000_0000_0000 ' set bit 14
   Phase_l = Phase_low
   Control_register = &B0010_0000_0000_0000

   9833clk = 1
   Fsync = 0
   Shiftout 9833data , 9833clk , Control_register , 0 , 16
   Waitus 1
   Fsync = 1

   Fsync = 0
   Shiftout 9833data , 9833clk , Phase_l , 0 , 16
   Fsync = 1

   Fsync = 0

   Shiftout 9833data , 9833clk , Phase_h , 0 , 16
   Fsync = 1
   Gosub Show_mod



Mod_exit:
   Return

Below_1000:
   If Mod_frequency = 50 Then Lcdat 5 , 1 , "AM " ; Mod_frequency ; "Hz " , 2
   If Mod_frequency <> 50 Then Lcdat 5 , 1 , "AM " ; Mod_frequency ; "Hz" , 2
   Return


Mod_to_frequency:
   Mod_number = Adc1_sample / 100                 ' gives range of 0 - 10
   If Mod_number = 0 Then Mod_frequency = 50
   If Mod_number = 1 Then Mod_frequency = 100
   If Mod_number = 2 Then Mod_frequency = 200
   If Mod_number = 3 Then Mod_frequency = 400
   If Mod_number = 4 Then Mod_frequency = 1000
   If Mod_number = 5 Then Mod_frequency = 2000
   If Mod_number = 6 Then Mod_frequency = 3000
   If Mod_number = 7 Then Mod_frequency = 5000
   If Mod_number = 8 Then Mod_frequency = 6000
   If Mod_number = 9 Then Mod_frequency = 8000
   If Mod_number = 10 Then Mod_frequency = 10000
   Return

Show_mod:
   Print "Mod = " ; Mod_frequency ; "Hz" ; " Phase register = " ; Hex(phase_register) ; Chr(cr);

   If Mod_frequency < 1000 Then Gosub Below_1000

   If Mod_frequency = 1000 Then Lcdat 5 , 1 , "AM 1 kHz" , 2
   If Mod_frequency = 2000 Then Lcdat 5 , 1 , "AM 2 kHz" , 2
   If Mod_frequency = 3000 Then Lcdat 5 , 1 , "AM 3 kHz" , 2
   If Mod_frequency = 4000 Then Lcdat 5 , 1 , "AM 4 kHz" , 2
   If Mod_frequency = 5000 Then Lcdat 5 , 1 , "AM 5 kHz" , 2
   If Mod_frequency = 6000 Then Lcdat 5 , 1 , "AM 6 kHz" , 2
   If Mod_frequency = 8000 Then Lcdat 5 , 1 , "AM 8 kHz" , 2
   If Mod_frequency = 10000 Then Lcdat 5 , 1 , "AM 10kHz" , 2
   Gosub Set_fm_reload , 2
   Return

' ****************************** READ RV2 ********************************************
'
' Read potentiometer RV2 for special functions

Read_rv2:
   Mod_save = Mod_number
   Adc0_reading = Getadc(0)                       ' gets value 0-1023
   Adc0_sample = Adc0_reading
   Adc0_reading = Getadc(0)
   Adc0_sample = Adc0_sample + Adc0_reading
   Adc0_reading = Getadc(0)
   Adc0_sample = Adc0_sample + Adc0_reading
   Adc0_reading = Getadc(0)
   Adc0_sample = Adc0_sample + Adc0_reading
   Adc0_sample = Adc0_sample / 4                  ' get average

   Function_diff = Adc0_sample - Previous_adc0_sample
   If Abs(function_diff) < 50 Then Goto Rv2_exit  ' only for => 50
   Previous_adc0_sample = Adc0_sample
   Func_value = Adc0_sample / 95

   Print "RV2 = " ; Func_value ; Chr(cr);
   If Func_value < 9 Then Gosub Below_nine

   If Func_value > 9 Then Set Calibration_flag
   If Func_value > 9 Then Lcdat 5 , 1 , " Calib  "
   If Func_value > 9 Then Lcdat 7 , 1 , Mhz_factor

   If Func_value < 3 Then Deviation_value = 1
   If Func_value = 3 Then Deviation_value = 2
   If Func_value = 4 Then Deviation_value = 2
   'If Func_value = 5 Then Deviation_value = 3
   If deviation_value=1 then gosub  Dev_25
   If deviation_value=2 then gosub  Dev_50

'   If Func_value = 6 Then Deviation_value = 3
Rv2_exit:
   Return

Below_nine:
   Reset Calibration_flag
   Mod_number = Mod_save
   Gosub Mod_to_frequency
   Gosub Show_mod
   Return

' ***************************** FREQUENCY MODULATION **********************
'
' Timer interrupt is at 9,600/second. Construct 400Hz sine wave as variation
' of frequency up to 2.5 kHz deviation plus and minus.
' Sample at 15 degree intervals. Phase is 23.86/Hz

'
'  x    sin x  Delta f   Delta Phase
' ----------------------------------
'   0       0        0          0
'  15     0.259     647      15,437
'  30     0.500    1250      29,825
'  45     0.707    1767      42,160
'  60     0.877    2192      52,301
'  75     0.966    2415      57,622
'  90     1.000    2500      59,650
'  105    0.966    2415      57,622
'  120    0.877    2192      52,301
'  135    0.707    1767      42,160
'  150    0.500    1250      29,825
'  165    0.259     647      15,437
'  180      0       0           0
'  195   -0.259   -647      -15,437
'  210   -0.500   -1250     -29,825
'  225   -0.707   -1767     -42,160
'  240   -0.877   -2192     -52,301
'  255   -0.966   -2415     -57,622
'  270   -1.000   -2500     -59,650
'  285   -0.966   -2415     -57,622
'  300   -0.877   -2192     -52,301
'  315   -0.707   -1767     -42,160
'  330   -0.500   -1250     -29,825
'  345   -0.259   -647      -15,437



Frequency_modulation:
' Set Portb.6
 Sample_bit = 0
 Phase = Phase_save
 If Deviation_value = 1 Then Gosub 2500_deviation
 If Deviation_value <> 1 Then Gosub 5000_deviation
' Reset Portb.6
   Return

2500_deviation:
   On Fm_sample Gosub O_0 , O_1 , O_2 , O_3 , O_4 , O_5 , O_6 , O_7 , O_8 , O_9 , O_10 , O_11

   W_4 = New_phase
   Rotate New_phase , Right , 8
   W_3 = New_phase
   Rotate New_phase , Right , 8
   W_2 = New_phase
   Rotate New_phase , Right , 8
   W_1 = New_phase
   Gosub Upload_five
   Return

' ---------------------------------------------------------------------------------------------

5000_deviation:
   On Fm_sample Gosub P_0 , P_1 , P_2 , P_3 , P_4 , P_5 , P_6 , P_7 , P_8 , P_9 , P_10 , P_11

   W_4 = New_phase
   Rotate New_phase , Right , 8
   W_3 = New_phase
   Rotate New_phase , Right , 8
   W_2 = New_phase
   Rotate New_phase , Right , 8
   W_1 = New_phase
   Gosub Upload_five
   Return

' ----------------------------------------------------------------------------------------------


' Phase deviation for 2.5 kHz

O_0:
 Phase_deviation = 0
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

O_1:
 Phase_deviation = 15437
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

O_2:
  Phase_deviation = 29825
  If Polarity = 0 Then New_phase = Phase + Phase_deviation
  If Polarity = 1 Then New_phase = Phase - Phase_deviation
  Return

O_3:
 Phase_deviation = 42160
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
  Return

O_4:
 Phase_deviation = 52301
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
  Return

O_5:
 Phase_deviation = 57622
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

O_6:
 Phase_deviation = 59650
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

O_7:
 Phase_deviation = 57622
 New_phase = Phase + Phase_deviation
 Return

O_8:
 Phase_deviation = 52301
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

O_9:
 Phase_deviation = 42160
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

O_10:
 Phase_deviation = 29825
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

 O_11:
 Phase_deviation = 15437
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

' ************************************************************************

' Phase deviation for 5 kHz

P_0:
 Phase_deviation = 0
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_1:
 Phase_deviation = 30874
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_2:
  Phase_deviation = 59650
  If Polarity = 0 Then New_phase = Phase + Phase_deviation
  If Polarity = 1 Then New_phase = Phase - Phase_deviation
  Return

P_3:
 Phase_deviation = 84320
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
  Return

P_4:
 Phase_deviation = 104602
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
  Return

P_5:
 Phase_deviation = 115244
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_6:
 Phase_deviation = 119300
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_7:
 Phase_deviation = 115244
 New_phase = Phase + Phase_deviation
 Return

P_8:
 Phase_deviation = 104602
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_9:
 Phase_deviation = 84320
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_10:
 Phase_deviation = 59650
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return

P_11:
 Phase_deviation = 30874
 If Polarity = 0 Then New_phase = Phase + Phase_deviation
 If Polarity = 1 Then New_phase = Phase - Phase_deviation
 Return


' ********************************** SET FM RELOAD **********************************

' Set FM reload sets timer 1 interrupt rate.

Set_fm_reload:

   If Mod_number = 0 Then Fm_reload = 16667
   If Mod_number = 1 Then Fm_reload = 8333
   If Mod_number = 2 Then Fm_reload = 4167
   If Mod_number = 3 Then Fm_reload = 2083
   If Mod_number = 4 Then Fm_reload = 1667
   If Mod_number = 5 Then Fm_reload = 1389
   If Mod_number = 6 Then Fm_reload = 1190
   If Mod_number = 7 Then Fm_reload = 1042
   If Mod_number = 8 Then Fm_reload = 926
   If Mod_number => 9 Then Fm_reload = 760


   If Mod_number = 0 Then Mod_frequency = 50
   If Mod_number = 1 Then Mod_frequency = 100
   If Mod_number = 2 Then Mod_frequency = 200
   If Mod_number = 3 Then Mod_frequency = 400
   If Mod_number = 4 Then Mod_frequency = 500
   If Mod_number = 5 Then Mod_frequency = 600
   If Mod_number = 6 Then Mod_frequency = 700
   If Mod_number = 7 Then Mod_frequency = 800
   If Mod_number = 8 Then Mod_frequency = 900
   If Mod_number => 9 Then Mod_frequency = 1000

   If Mod_number < 9 Then Gosub Below_9

   If Mod_number => 9 Then Lcdat 7 , 1 , "FM 1 kHz" , 2

Sfm_exit:
   Return

Below_9:
   If Mod_frequency = 50 Then Lcdat 7 , 1 , "FM " ; Mod_frequency ; "Hz " , 2
    If Mod_frequency <> 50 Then Lcdat 7 , 1 , "FM " ; Mod_frequency ; "Hz" , 2
    Return




   $include "font16x16.font"